<?php
/**
 * @file components/PKPStatsPublicationPage.php
 *
 * Copyright (c) 2014-2021 Simon Fraser University
 * Copyright (c) 2000-2021 John Willinsky
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * @class PKPStatsPublicationPage
 *
 * @ingroup classes_controllers_stats
 *
 * @brief A class to prepare the data object for the publication statistics
 *   UI component
 */

namespace PKP\components;

use PKP\statistics\PKPStatisticsHelper;

class PKPStatsPublicationPage extends PKPStatsComponent
{
    /** @var array A timeline of stats (eg - monthly) for a graph */
    public $timeline = [];

    /** @var string Which time segment (eg - month) is displayed in the graph */
    public $timelineInterval = PKPStatisticsHelper::STATISTICS_DIMENSION_MONTH;

    /** @var string Which views to show in the graph. Supports `abstract` or `galley`. */
    public $timelineType = '';

    /** @var array List of items to display stats for */
    public $items = [];

    /** @var int The maximum number of items that stats can be shown for */
    public $itemsMax = 0;

    /** @var int How many items to show per page */
    public $count = 30;

    /** @var string Order items by this property */
    public $orderBy = '';

    /** @var string Order items in this direction: ASC or DESC*/
    public $orderDirection = 'DESC';

    /** @var string A search phrase to filter the list of items */
    public $searchPhrase = null;

    /** @var string When Geographical statistic are enabled, options: countries/regions/cities */
    public $geoReportType = null;



    /**
     * Retrieve the configuration data to be used when initializing this
     * handler on the frontend
     *
     * @return array Configuration data
     */
    public function getConfig()
    {
        $config = parent::getConfig();

        $config = array_merge(
            $config,
            [
                'timeline' => $this->timeline,
                'timelineInterval' => $this->timelineInterval,
                'timelineType' => $this->timelineType,
                'items' => $this->items,
                'dateRangeLabel' => __('stats.dateRange'),
                'searchPhraseLabel' => __('common.searchPhrase'),
                'itemsOfTotalLabel' => __('stats.publications.countOfTotal'),
                'betweenDatesLabel' => __('stats.downloadReport.betweenDates'),
                'allDatesLabel' => __('stats.dateRange.allDates'),
                'allFiltersLabel' => __('stats.downloadReport.allFilters'),
                'commonSubmissionsLabel' => __('common.publications'),
                'timelineTypeLabel' => __('stats.timelineType'),
                'timelineIntervalLabel' => __('stats.timelineInterval'),
                'viewsLabel' => __('submission.views'),
                'downloadsLabel' => __('submission.downloads'),
                'dayLabel' => __('common.day'),
                'monthLabel' => __('common.month'),
                'timelineDescriptionLabel' => __('stats.timeline.downloadReport.description'),
                'itemsMax' => $this->itemsMax,
                'count' => $this->count,
                'offset' => 0,
                'searchPhrase' => null,
                'orderBy' => $this->orderBy,
                'orderDirection' => $this->orderDirection,
                'isLoadingTimeline' => false,
                'geoReportType' => $this->geoReportType
            ]
        );

        return $config;
    }
}
